<?php
if ( et_theme_builder_overrides_layout( ET_THEME_BUILDER_HEADER_LAYOUT_POST_TYPE ) || et_theme_builder_overrides_layout( ET_THEME_BUILDER_FOOTER_LAYOUT_POST_TYPE ) ) {
    // Skip rendering anything as this partial is being buffered anyway.
    // In addition, avoids get_sidebar() issues since that uses
    // locate_template() with require_once.
    return;
}

/**
 * Fires after the main content, before the footer is output.
 *
 * @since 3.10
 */
do_action( 'et_after_main_content' );

if ( 'on' === et_get_option( 'divi_back_to_top', 'false' ) ) : ?>

	<span class="et_pb_scroll_top et-pb-icon"></span>

<?php endif; ?>

<div class="footer-map-section">
<?php dynamic_sidebar("et_pb_widget_area_8"); ?>
</div>

<?php if ( ! is_page_template( 'page-template-blank.php' ) ) : ?>

			<footer id="main-footer">
				<?php get_sidebar( 'footer' ); ?>


		<?php
			if ( has_nav_menu( 'footer-menu' ) ) : ?>

				<div id="et-footer-nav">
					<div class="container">
						<?php
							wp_nav_menu( array(
								'theme_location' => 'footer-menu',
								'depth'          => '1',
								'menu_class'     => 'bottom-nav',
								'container'      => '',
								'fallback_cb'    => '',
							) );
						?>
					</div>
				</div> <!-- #et-footer-nav -->

			<?php endif; ?>

				<div id="footer-bottom">
					<div class="container clearfix">
				<?php
					if ( false !== et_get_option( 'show_footer_social_icons', true ) ) {
						get_template_part( 'includes/social_icons', 'footer' );
					}

					// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
					echo et_core_fix_unclosed_html_tags( et_core_esc_previously( et_get_footer_credits() ) );
					// phpcs:enable
				?>
					</div>	<!-- .container -->
				</div>
			</footer> <!-- #main-footer -->
		</div> <!-- #et-main-area -->

<?php endif; // ! is_page_template( 'page-template-blank.php' ) ?>
	<!-- Sticky Links -->	
	<div class="sticky-button-bar">
	<?php  dynamic_sidebar("et_pb_widget_area_7");   ?>
	</div>
	</div> <!-- #page-container -->
	
	<?php wp_footer(); ?>

  <script>
			jQuery('.testimonial-rotator').slick({
			  dots: false,
			  centerMode: true,
  			  infinite: true,
			  autoplay: false,
				 arrows: true,
            prevArrow:"<button type='button' data-role='none' aria-label='Next' role='button' class='slick-prev'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' data-role='none' aria-label='Next' role='button' class='slick-next'><i class='fa fa-angle-right' aria-hidden='true'></i></button>",
			  autoplaySpeed: 5000,
			  speed: 1000,
			
			  slidesToShow: 3,
			  adaptiveHeight: true,
			  slidesToScroll: 1, 
			  fade: false,
			  respondTo: 'window',
			  pauseOnHover: true,				
			   responsive: [
								{
								  breakpoint: 767,
								  settings: {
									slidesToShow: 1,
									infinite: true,
									dots: false
								  }
								}
							]
			});
			</script>
</body>
</html>
